<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/
 */
/********************* META BOX DEFINITIONS ***********************/
/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
// Better has an underscore as last sign
$prefix = '';
global $meta_boxes;
$meta_boxes = array();
// 1st meta box
$meta_boxes[] = array(
// Meta box id, UNIQUE per meta box. Optional since 4.1.5
'id' => 'themeinfo',
// Meta box title - Will appear at the drag and drop handle bar. Required.
'title' => 'زمینه دلخواه',
// Post types, accept custom post types as well - DEFAULT is array('post'). Optional.
'pages' => array( 'product' ),
// Where the meta box appear: normal (default), advanced, side. Optional.
'context' => 'normal',
// Order of meta box: high (default), low. Optional.
'priority' => 'high',
// List of meta fields
'fields' => array(

array(
// Field name - Will be used as label
'name'  => 'تصویر شاخص <span> در صورتی که قصد نمایش ویدیو ندارید </span>',
// Field ID, i.e. the meta key
'id'    => "shalhes",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'دوره گواهی تایید کیفیت دارد',
// Field ID, i.e. the meta key
'id'    => "door1",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),
array(
// Field name - Will be used as label
'name'  => 'دوره دارای پشتیبانی می باشد',
// Field ID, i.e. the meta key
'id'    => "door2",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),array(
// Field name - Will be used as label
'name'  => 'دسترسی همیشگی به دروس',
// Field ID, i.e. the meta key
'id'    => "door3",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'دارای مدرک رسمی',
// Field ID, i.e. the meta key
'id'    => "door4",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'لینک دانلود تمامی فایل های دوره',
// Field ID, i.e. the meta key
'id'    => "door5",
'type'  => 'text',
// Default value (optional)
'std'   => '#',
),
array(
// Field name - Will be used as label
'name'  => 'متن دکمه دانلود تمامی فایل های دوره',
// Field ID, i.e. the meta key
'id'    => "door666",
'type'  => 'text',
// Default value (optional)
'std'   => 'دانلود فایل های دوره',
),

array(
// Field name - Will be used as label
'name'  => 'تخصص مدرس',
// Field ID, i.e. the meta key
'id'    => "takhasos",
'type'  => 'text',
// Default value (optional)
'std'   => 'برنامه نویس',
),

array(
'type' => 'color',
                'name' => esc_html__( 'رنگ پس زمینه کاور', 'online-generator' ),
                'id'   => $prefix . 'coloriran',
),

array(
// Field name - Will be used as label
'name'  => 'ساعت آموزش',
// Field ID, i.e. the meta key
'id'    => "time",
'type'  => 'text',
// Default value (optional)
'std'   => '15 دقیقه',
),
array(
// Field name - Will be used as label
'name'  => 'سطح دوره',
// Field ID, i.e. the meta key
'id'    => "sath",
'type'  => 'text',
// Default value (optional)
'std'   => 'پیشرفته',
),
array(
// Field name - Will be used as label
'name'  => 'تعداد دروس',
// Field ID, i.e. the meta key
'id'    => "dars",
'type'  => 'text',
// Default value (optional)
'std'   => '16 درس',
),
array(
// Field name - Will be used as label
'name'  => 'مدرک دوره',
// Field ID, i.e. the meta key
'id'    => "madrak",
'type'  => 'text',
// Default value (optional)
'std'   => 'مدرک تخصصی',
),
array(
// Field name - Will be used as label
'name'  => 'نوع دوره',
// Field ID, i.e. the meta key
'id'    => "nodor",
'type'  => 'text',
// Default value (optional)
'std'   => 'آنلاین',
),
array(
// Field name - Will be used as label
'name'  => 'زبان دوره',
// Field ID, i.e. the meta key
'id'    => "zaban",
'type'  => 'text',
// Default value (optional)
'std'   => 'فارسی',
),
array(
// Field name - Will be used as label
'name'  => 'پیش نیاز های دوره',
// Field ID, i.e. the meta key
'id'    => "pish",
'type'  => 'text',
// Default value (optional)
'std'   => 'بدون پیشنیاز',
),
array(
// Field name - Will be used as label
'name'  => 'درصد تکمیل دوره',
// Field ID, i.e. the meta key
'id'    => "darsad",
'type'  => 'text',
// Default value (optional)
'std'   => '40',
),

array(
// Field name - Will be used as label
'name'  => 'لینک ویدیو',
// Field ID, i.e. the meta key
'id'    => "video",
'type'  => 'text',
// Default value (optional)
'std'   => '#',
),
array(
// Field name - Will be used as label
'name'  => 'تصویر ویدیو',
// Field ID, i.e. the meta key
'id'    => "tasvirv",
'type'  => 'file-input',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'فعال سازی پشتیبانی',
// Field ID, i.e. the meta key
'id'    => "psohtiban",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),

array(
// Field name - Will be used as label
'name'  => 'شماره تماس پشتیبان',
// Field ID, i.e. the meta key
'id'    => "pone",
'type'  => 'text',
// Default value (optional)
'std'   => '021-000-000',
),

array(
// Field name - Will be used as label
'name'  => 'ایمیل پشتیبان',
// Field ID, i.e. the meta key
'id'    => "ptwo",
'type'  => 'text',
// Default value (optional)
'std'   => 'info@youremail.com',
),

array(
// Field name - Will be used as label
'name'  => 'آدرس پشتیبان',
// Field ID, i.e. the meta key
'id'    => "pthree",
'type'  => 'text',
// Default value (optional)
'std'   => 'تهران',
),
array(
// Field name - Will be used as label
'name'  => 'فعال سازی پشتیبانی از طریق شبکه اجتماعی',
// Field ID, i.e. the meta key
'id'    => "pfour",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),
array(
// Field name - Will be used as label
'name'  => 'لینک تلگرام',
// Field ID, i.e. the meta key
'id'    => "pfive",
'type'  => 'text',
// Default value (optional)
'std'   => '#',
),
array(
// Field name - Will be used as label
'name'  => 'لینک اینستاگرام',
// Field ID, i.e. the meta key
'id'    => "psix",
'type'  => 'text',
// Default value (optional)
'std'   => '#',
),

array(
// Field name - Will be used as label
'name'  => 'توضیحات پشتیبانی',
// Field ID, i.e. the meta key
'id'    => "toozh",
'type'  => 'textarea',
// Default value (optional)
'std'   => '#',
),


array(
'type' => 'color',
                'name' => esc_html__( 'رنک نیمه پس زمینه', 'online-generator' ),
                'id'   => $prefix . 'color_r7ghubsxvw',
),
array(
// Field name - Will be used as label
'name'  => 'فعال سازی ویژگی دلخواه',
// Field ID, i.e. the meta key
'id'    => "vijon",
'type'  => 'switch',
// Default value (optional)
'std'   => '',
),
 array(
    'id'      => 'field_id',
    'name'    => 'ویژگی دلخواه <a href="https://pictogrammers.github.io/@mdi/font/3.2.89/">مشاهده لیست ایکون ها</a>',
    'type'    => 'fieldset_text',

    // Options: array of key => Label for text boxes
    // Note: key is used as key of array of values stored in the database
    'options' => array(
        'name'    => 'عنوان ویژگی',
        'address' => 'متن ویژگی',
		'dotiz' => 'کد آیکون متریال دیزاین',

    ),

    // Is field cloneable?
    'clone' => true,
),

 

	array(
				'id' => $prefix . 'bishtar',
				'name' => esc_html__( 'توضیحات بیشتر دوره', 'metabox-online-generator' ),
				'type' => 'wysiwyg',
			),
			
),





);
/********************* META BOX REGISTERING ***********************/
/**
 * Register meta boxes
 *
 * @return void
 */
function wtf_register_meta_boxes()
{
// Make sure there's no errors when the plugin is deactivated or during upgrade
if ( !class_exists( 'RW_Meta_Box' ) )
return;
global $meta_boxes;
foreach ( $meta_boxes as $meta_box )
{
new RW_Meta_Box( $meta_box );
}
}
// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'wtf_register_meta_boxes' ); ?>