<?php
namespace Elementor;

class blog3 extends Widget_Base {
	
	public function get_name() {
		return 'blog3';
	}
	
	public function get_title() {
		return 'وبلاگ - لیست مطالب 2';
	}
	
  public function get_icon() {
		return 'eicon eicon-post-content';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
	
	protected function register_controls() {

		$post_cat = array();
		$categories = get_terms("category");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$post_cat[ $category->term_id ] = $category->name;
			}
		}
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		


		
		$this->add_control(
			'title',
			[
				'label' => 'عنوان',
				'label_block' => true,
				'default' => 'مطالب',
				'type' => Controls_Manager::TEXT,
				'placeholder' => 'عنوان را وارد نمایید',
			]
		);

		$this->add_control(
			'post_sort',
			[
				'label' => 'مرتب سازی مطالب',
				'type' => Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  => 'آخرین مطالب',
					'random' => 'مطالب تصادفی',
					'viewed' => 'مطالب پربازدید',
				],
			]
		);

		$this->add_control(
			'post_cat',
			[
				'label' => 'دسته بندی مطالب',
				'type' => Controls_Manager::SELECT2,
				'options' => $post_cat,
			]
		);




		$this->add_control(
			'ptotalcount',
			[
				'label' => 'تعداد مطالب',
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 8,
			]
		);


		$this->end_controls_section();
		
		
        	       $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
	       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش موضوع', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);


		       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تاریخ', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		

		        
		
		    
		
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             



		   
		   $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-list-12342346 h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		 		 
		   	  
			  
			  		   $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ متن موضوع', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .rrf-eee222266 .mozooo5656' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   		  		   $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .rel-comment56-tedad.left98656' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	  		   $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه ایکون تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .rel-comment56-tedad.left98656 i' => 'background: {{VALUE}} !important',
				],
			]
           );
		      
		   	  		   $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ ایکون تاریخ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .rel-comment56-tedad.left98656 i' => 'color: {{VALUE}} !important',
				],
			]
           );
		      	  		  
						  
		
					
				  $this->add_responsive_control(
                        'farnamborder3',
                        [
                            'label' => esc_html__( 'گردی دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .rrf-eee222266' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
								
				  $this->add_responsive_control(
                        'farnamborder4',
                        [
                            'label' => esc_html__( 'گردی موضوع', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .rrf-eee222266 .mozooo5656' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			
			
				  $this->add_responsive_control(
                        'farnamborder5',
                        [
                            'label' => esc_html__( 'گردی ایکون تاریخ', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .meta-rel-sepid566 i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );	
			
			
        $this->end_controls_section();


	}
	
	protected function render() {
		global $az_data;
		$settings = $this->get_settings_for_display();
		$post_cat = $settings['post_cat']; ?>
        <div class="rcon">
			<div class="post-block m-product ir99">
		
			<?php
			$post_sort = $settings['post_sort'];
				switch ($post_sort) {
					case 'latest':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
						break;
					case 'viewed':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'meta_key' => 'post_views_count',
						'orderby' => 'meta_value_num',
						'order' => 'DESC'  );
						break;
					case 'random':
						$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'orderby'        => 'rand'  );
						break;
					default:
					$args = array(
						'posts_per_page' => $settings['ptotalcount'],
						'post_type' => 'post',
						'post_status' => 'publish',
						'order' => 'DESC'  );
					}
					if ( $post_cat ) {
						$args['tax_query'] = array(
							array(
							'taxonomy' => 'category',
							'field' => 'term_id',
							'terms' => $post_cat
							)
						);
					}
				$postsquery = new \WP_Query( $args );
			?>
			
			<?php if ( $postsquery->have_posts() ) { ?>


			<?php while ( $postsquery->have_posts() ) : $postsquery->the_post(); ?>
<div class="product-list2342346 inblog6">
<div class="product-list-12342346">

<a class="rrf-eee65" href="<?php the_permalink(); ?>">
<div class="rrf-eee222266">
	<?php the_post_thumbnail(''); ?>
	
										<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

	<?php $option_meta = rwmb_meta('mozo'); if (!empty($option_meta)) { ?>
<div class="mozooo5656" style="background: 	<?php $option_meta = rwmb_meta('mozocolor'); if (!empty($option_meta)) { ?><?php echo $option_meta; ?><?php } ?>
;">	<?php $option_meta = rwmb_meta('mozo'); if (!empty($option_meta)) { ?>
<?php echo $option_meta; ?>	<?php } ?>
</div>
	<?php } ?><?php } ?>
	
											<?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>

<div class="meta-rel-sepid566">

<div class="rel-comment56-tedad left98656"><i class="fi fi-rr-calendar"></i><?php the_time('d M Y'); ?>

</div>
</div><?php } ?>
	</div>
<h3><?php the_title(); ?></h3>
</a>


</div>

</div>
			<?php endwhile; ?>
				
			<?php 
			} else {		
			echo 'لطفا ابتدا نوشته ای را اضافه نمایید.';}
			wp_reset_postdata();
			?>
			</div>
   		</div>
        <?php

	}

}