<?php
namespace Elementor;

class blog1 extends Widget_Base {
	
	public function get_name() {
		return 'blog1';
	}
	
	public function get_title() {
		return 'وبلاگ - پست تکی';
	}
	
	public function get_icon() {
		return 'eicon-navigator';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'title1',
			[
				'label' => __( 'نام نویسنده', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'title2',
			[
				'label' => __( 'تاریخ انتشار', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'cat',
			[
				'label' => __( 'اسم موضوع', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک عنوان وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'link',
			[
				'label' => __( 'لینک نوشته', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'یک لینک وارد کنید', 'elementor' ),
			]
		);
		
$this->add_control(
			'color',
			[
				'label' => __( 'رنگ پس زمینه موضوع', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .targ' => 'background: {{VALUE}}',
				],
			]
		);
		
		
		$this->add_control(
			'color21',
			[
				'label' => __( 'رنگ متن موضوع', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .targ' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'انتخاب تصویر', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);


	
	
		$this->end_controls_section();
		
		
		       

	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
 
             $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .box-asli-blog h3' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		        $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ نام نویسنده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .nevisanfe' => 'color: {{VALUE}} !important',
				],
			]
           );
		        $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ زمان انتشار', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tarikh' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه المان کناری', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
					$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background1',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .box-asli-blog h3::before',
			]
		);
					   	   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه المان کناری', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .box-asli-blog h3::before',
			]
		);
		
		 $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .single-post-13' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                                '{{WRAPPER}} .single-post-133' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
			 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی موضوع نوشته', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-asli-blog .targ' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();


	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo  '
<div class="single-post-12">
<a href="' . $settings['link'] . '" class="single-post-13"
';
		echo 'style="background: url(' . $settings['image']['url'] . ')">';
echo '		<div class="single-post-133"></div>
';
		echo  "
		<div class='box-asli-blog'>
<div class='targ'>$settings[cat]</div>

<h3>$settings[title]</h3>
<div class='toz-4423'>
<div class='nevisanfe'>
$settings[title1]</div>
<div class='tarikh'>
						<i class='fi fi-rr-calendar'></i>
					$settings[title2]</div>

</div></div>
</a>
</div>
";
	}


	
	protected function _content_template() {

    }
	
	
}