<?php
namespace Elementor;

class wcategoryone extends Widget_Base {
	
	public function get_name() {
		return 'wcategoryone';
	}
	
	public function get_title() {
		return 'دسته بندی';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دسته بندی سپید', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
		$this->add_control(
			'link',
			[
				'label' => esc_html__( 'لینک', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'plugin-name' ),
				'placeholder' => esc_html__( 'لینک دسته بندی را وارد کنید', 'plugin-name' ),
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر دسته بندی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		
		   $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
	
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background4',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .sepid-rtl-cat-one',
			]
		);
				
	    $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه تصویر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-rtl-cat-one img' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sepid-category-one h5' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		
		    		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-rtl-cat-one' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sepid-rtl-cat-one img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
			echo "
			
			<a href='$settings[link]' target='_blank' class='koodak-cat-new-1'> <div class='sepid-category-one'><div class='sepid-rtl-cat-one'>
			";
					echo ' <img src="' . $settings['image']['url'] . '">
';
echo "
		
		";
				?>
	
		<?php
		echo"
			</div>
			<h5>$settings[title] </h5>
			</div></a>
";
	

	}


	
	protected function _content_template() {

    }
	
	
}