<?php
namespace Elementor;

class icondonya extends Widget_Base {
	
	public function get_name() {
		return 'icondonya';
	}
	
	public function get_title() {
		return 'ایکون دنیا';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
	$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		
		   $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'رنگ پس زمینه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
	
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background4',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .amar-icon-32-icon-23',
			]
		);
				   $this->add_control(
                        'titr-124444-44r45rw',
                        [
                            'label' => __( 'سایه ایکون', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'selector' => '{{WRAPPER}} .amar-icon-32-icon-23',
			]
		);	

		   	    $this->add_control(
'sepidcolor-243',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .amar-icon-32-icon-23' => 'color: {{VALUE}} !important',
				],
			]
           );
		   

	
		
		    		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی دور ایکون', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .amar-icon-32-icon-23' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
			
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();



?>
		<div class="amar-icon-32-icon-23">	<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
			
			</div>
			
		
		<?php
	
		
		

	}


	
	protected function _content_template() {

    }
	
	
}