<?php
namespace Elementor;

class imagevideo extends Widget_Base {
	
	public function get_name() {
		return 'imagevideo';
	}
	
	public function get_title() {
		return 'تصویر - ویدیو';
	}
	
 public function get_icon() {
		return 'eicon eicon-menu-bar';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }

	
	protected function register_controls() {


		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'محتوا', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'عنوان', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'دسته بندی سپید', 'plugin-name' ),
				'placeholder' => esc_html__( 'متن خود را وارد کنید', 'plugin-name' ),
			]
		);
	
		$this->add_control(
			'image',
			[
				'label' => __( 'تصویر اصلی', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
				$this->add_control(
			'image122',
			[
				'label' => __( 'تصویر ویدیو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		
		   $this->add_control(
			'widget_title',
			[
				'label' => __( 'لینک ویدیو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#', 'plugin-domain' ),
				'placeholder' => __( 'لینک ویدیو را وارد کنید', 'plugin-domain' ),
			]
		);
		$this->end_controls_section();
      


  $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );

		
		   $this->add_control(
                        'titr-12-3w4',
                        [
                            'label' => __( 'پس زمینه ایکون ویدیو', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
	
	$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background4',
				'label' => esc_html__( 'Background', 'plugin-name' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .box-video-3',
			]
		);
				
				
					   	   $this->add_control(
                        'titr-124444-44r45rwtererrt1',
                        [
                            'label' => __( 'سایه دکمه ویدیو', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttertafdow1',
				'selector' => '{{WRAPPER}} .box-video-3',
			]
		);
	
		   
		   		
		    $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ ایکون', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-video-3' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		
		    		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس دور تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .video-image-box img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
					 $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی ایکون ویدیو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-video-3' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		echo '<div class="video-image-box"><img src="' . $settings['image']['url'] . '"><div class="box-video-1"><div class="box-video-2" onclick="PopUp1()"><div class="box-video-3"><i class="fi fi-rr-play"></i></div></div></div></div>
		

		
		';
			?>
		
			<div id="popup-wrapper1" class="modal modalvideo">

  <!-- Modal content -->
  <div class="modal-content1">
    <a href="#modal-close" class="modal-close" onClick="PopUp1('hide1')">بستن</a>   	

<div class="video-sepid-p-single">
<video id="video1" preload="none" controls="" poster="<?php echo '' . $settings['image122']['url'] . ''; ?>">
                        <source src="<?php echo '' . $settings['widget_title'] . ''; ?>" type="video/mp4">
                    </video>
                    

</div>

  </div>

</div>

	<script>
    function PopUp1(hideOrshow) {
  if (hideOrshow == 'hide1') {
    document.getElementById('popup-wrapper1').style.display = 'none';
    document.getElementById('video1').pause(); // add this
  }
  else {
    document.getElementById('popup-wrapper1').removeAttribute('style');
        document.getElementById('popup-wrapper1').style.display = "block";

  }
}
</script>
		<?php
	
		
		

	}


	
	protected function _content_template() {

    }
	
	
}