<?php
namespace Elementor;

class search extends Widget_Base {
	
	public function get_name() {
		return 'search';
	}
	
	public function get_title() {
		return 'جستجو';
	}
	
	public function get_icon() {
		return 'eicon-search';
	}
	
	public function get_categories() {
		return [ 'donya' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'جستجو دوره آموزشی', 'elementor' ),
			]
		);
			
		$this->end_controls_section();
	     $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


		   
		   $this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1' => 'background: {{VALUE}} !important',
				],
			]
           );
		   $this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن جستجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .search-field' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه جستجوگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search i' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ ایکون جستجوگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	   $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه هاور جستجوگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search:hover i' => 'background: {{VALUE}} !important',
				],
			]
           );
		      	   $this->add_control(
'sepidcolor-6',
			[
				'label' => __( 'رنگ هاور ایکون جستجوگر', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search:hover i' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sssbox.newsearch.yad-2020-1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		        $this->add_responsive_control(
                        'sepidborder-2',
                        [
                            'label' => esc_html__( 'گردی جستجوگر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sssbox.newsearch.yad-2020-1 .submit.icon-search i' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   		$this->end_controls_section();

    }

	protected function render() {
		$settings = $this->get_settings_for_display();
		


		?>
      <div class="sssbox newsearch yad-2020-1"><form role="search" method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	
	<input type="search" id="checksearch" class="search-field" placeholder="<?php echo '' . $settings['title'] . ''; ?>" value="<?php echo get_search_query(); ?>" name="s" />
 <button type="submit" class="submit icon-search"><i class="fa fa-search"></i></button>
<input type="hidden" name="post_type" value="product" /></form>
</div>
		<?php


	}


	
	protected function _content_template() {

    }
	
	
}