<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class peoductlist extends Widget_Base {

    public function get_name() {
        return 'peoductlist';
    }
    
    public function get_title() {
        return __( 'لیست محصولات 2', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            
  $this->add_control(
			'code',
			[
				'label' => __( 'کد اختصاصی تب', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'tab54', 'plugin-domain' ),
				'placeholder' => __( 'مثلا : tab25', 'plugin-domain' ),
			]
		);
            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           


        $this->end_controls_section();


         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش تعداد دانشجو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش نوع دوره', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		

		
		
  
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


		   	      $this->add_control(
'sepidcolor-543534',
			[
				'label' => __( 'رنگ پس زمینه محصولات', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-donya-list-tabmotete' => 'background: {{VALUE}} !important',
				],
			]
           );
			   	   $this->add_control(
                        'titr-124444-44r45rwtrt155',
                        [
                            'label' => __( 'سایه باکس اصلی', 'woolentor' ),
                            'type' => Controls_Manager::HEADING,
                                              ]
                    );
$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shttafdow51',
				'selector' => '{{WRAPPER}} .product-donya-list-tabmotete',
			]
		);
		
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .asdfsadf444pricemotete .mizan-tab' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   		
		   		   	      $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .asdfsadf444pricemotete .mizan-tab' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
					 		   	      $this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-meta-tab-pmotete h3' => 'color: {{VALUE}} !important',
				],
			]
           );
			
		   
		   					 		   	      $this->add_control(
'sepidcolor-10',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-two-boxmotete del' => 'color: {{VALUE}} !important',
				],
			]
           );
		      					 		   	      $this->add_control(
'sepidcolor-11',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-two-boxmotete ins' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .price-two-boxmotete' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      					 		   	      $this->add_control(
'sepidcolor-12',
			[
				'label' => __( 'رنگ پس زمینه نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144motete' => 'background: {{VALUE}} !important',
				],
			]
           );
		   			 		   	      $this->add_control(
'sepidcolor-13',
			[
				'label' => __( 'رنگ متن نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-price-tedad144motete' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   			 		   	      $this->add_control(
'sepidcolor-14',
			[
				'label' => __( 'رنگ پس زمینه تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sath-dore-conmotete' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   			 		   	      $this->add_control(
'sepidcolor-15',
			[
				'label' => __( 'رنگ متن تعدادت دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .sath-dore-conmotete' => 'color: {{VALUE}} !important',
				],
			]
           );
		     			 		   	      $this->add_control(
'sepidcolor-14f',
			[
				'label' => __( 'رنگ کادر جدا کننده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .asdfsadf444pricemotete' => 'border-top-color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   			 	
		   
		   
		   
		   			 
	
		   
		      $this->add_responsive_control(
                        'sepidborder2',
                        [
                            'label' => esc_html__( 'گردی کادر محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-donya-list-tabmotete' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		      $this->add_responsive_control(
                        'sepidborder24',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-donya-list-tabmotete img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		     $this->add_responsive_control(
                        'sepidborder3',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .asdfsadf444pricemotete .mizan-tab' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   

		   
		      $this->add_responsive_control(
                        'sepidborder5',
                        [
                            'label' => esc_html__( 'گردی نوع دوره', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .box-price-tedad144motete' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		     $this->add_responsive_control(
                        'sepidborder554',
                        [
                            'label' => esc_html__( 'گردی تعداد دانشجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .sath-dore-conmotete' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
        $this->end_controls_section();

             


          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-tab1motete';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-tab1motete';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-tab1motete';
                }
            }
        }

        ?>
                
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
					
 
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htppmotete">

     

  
                <div class="ht-row roozaye-barfimotete">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>



<div class="product-donya-list-tabmotete">
<div class="product-donya-list-tab-boxmotete">
<a href="<?php the_permalink(); ?>">

<div class="box-meta-tab-pmotete">


<h3><?php the_title(); ?></h3>
	<div class="price-buttonmotete"><?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>
	   					<?php $option_meta = rwmb_meta('nodor'); if (!empty($option_meta)) { ?>

<div class="box-price-tedad144motete"> <?php echo $option_meta; ?></div><?php } ?>
 <?php } ?><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
	<div class="sath-dore-conmotete"><i class="fi fi-rr-user"></i>
  <?php global $product;
$units_sold = get_post_meta( $product->get_id(), 'total_sales', true );
echo ''. sprintf( __( '%s', 'woocommerce' ), $units_sold ).''; ?> 

دانشجو
</div><?php } ?>
	
</div>


<div class="asdfsadf444pricemotete"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<?php global $product; if ( $product->is_on_sale() ) : ?>


<div class="mizan-tab">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>


</div>
	<?php
endif;
?><?php } ?>
<div class="price-two-boxmotete">
<?php global $product; echo $product->get_price_html(); ?>

	</div>
	</div>
	
	
	</div>

<div class="product-donya-list-tab-box-imgmotete">

<?php the_post_thumbnail(''); ?>


</div></a>
</div>
</div>
 

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       
            <?php endif;?>

		<script>
					function openCity<?php echo '' . $settings['code'] . ''; ?>(evt, cityName<?php echo '' . $settings['code'] . ''; ?>) {
  // Declare all variables
  var i, sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>, tablinks<?php echo '' . $settings['code'] . ''; ?>;

  // Get all elements with class="sepidhttabpane" and hide them
  sepidhttabpane<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("sepid-ht-tab-pane<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>[i].style.display = "none";
  }

  // Get all elements with class="tablinks" and remove the class "active"
  tablinks<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("tablinks<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < tablinks<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className = tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className.replace(" active", "");
  }

  // Show the current tab, and add an "active" class to the button that opened the tab
  document.getElementById(cityName<?php echo '' . $settings['code'] . ''; ?>).style.display = "block";
  evt.currentTarget.className += " active";
} 
					</script>

        <?php

    }


}


