<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class peoducttab extends Widget_Base {

    public function get_name() {
        return 'peoducttab';
    }
    
    public function get_title() {
        return __( 'لیست محصولات', 'woolentor' );
    }


      public function get_icon() {
		return 'eicon eicon-bag-medium';
    }
    
    public function get_categories() {
        return [ 'donya' ];
    }
    public function get_script_depends() {
        return [
            'woolentor-widgets-scripts',
            'slick',
        ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'woolentor-products',
            [
                'label' => esc_html__( 'تنظیمات محصول', 'woolentor' ),
            ]
        );
        
            
  $this->add_control(
			'code',
			[
				'label' => __( 'کد اختصاصی تب', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'tab54', 'plugin-domain' ),
				'placeholder' => __( 'مثلا : tab25', 'plugin-domain' ),
			]
		);
            $this->add_control(
                'woolentor_product_grid_product_filter',
                [
                    'label' => esc_html__( 'فیلتر شده', 'woolentor' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'recent',
                    'options' => [
                        'recent' => esc_html__( 'آخرین محصولات', 'woolentor' ),
                        'featured' => esc_html__( 'محضولات ویژه', 'woolentor' ),
                        'best_selling' => esc_html__( 'محصولات پر فروش', 'woolentor' ),
                        'sale' => esc_html__( 'محصولات تخفیفی', 'woolentor' ),
                        'top_rated' => esc_html__( 'محصولات محبوب', 'woolentor' ),
                    ],
                ]
            );
           
            $this->add_control(
              'woolentor_product_grid_row',
              [
                 'label'   => __( 'ستون ( فعلا فقط ۱ )', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 1,
                 'min'     => 1,
                 'max'     => 20,
                 'step'    => 1,
              ]
            );

            $this->add_control(
              'woolentor_product_grid_products_count',
              [
                 'label'   => __( 'تعداد محصولات', 'woolentor' ),
                 'type'    => Controls_Manager::NUMBER,
                 'default' => 4,
                 'min'     => 1,
                 'max'     => 100,
                 'step'    => 1,
              ]
            );

            $this->add_control(
                'woolentor_product_grid_categories',
                [
                    'label' => esc_html__( 'دسته بندی محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SELECT2,
                    'label_block' => true,
                    'multiple' => true,
                    'options' => Wootar_woocommerce_product_categories(),
                ]
            );
           

                     $this->add_control(
                'producttab',
                [
                    'label' => esc_html__( 'تب محصولات', 'woolentor' ),
                    'type' => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            

        $this->end_controls_section();


         $this->start_controls_section(
            'farnam_product_style_1',
            [
                'label' => esc_html__( 'تنظیمات فعال سازی', 'woolentor' ),
            ]
        );

		
		       $this->add_control(
			'farnamoneshow1',
			[
				'label' => __( 'نمایش ویدیو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

       $this->add_control(
			'farnamoneshow2',
			[
				'label' => __( 'نمایش تخفیف', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		       $this->add_control(
			'farnamoneshow3',
			[
				'label' => __( 'نمایش نوع دوره', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
       $this->add_control(
			'farnamoneshow4',
			[
				'label' => __( 'نمایش تعداد دانشجو', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'نمایش', 'your-plugin' ),
				'label_off' => __( 'مخفی', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		
		
  
        $this->end_controls_section();


        
	       $this->start_controls_section(
            'farnam_product_style_2',
            [
                'label' => esc_html__( 'تنظیمات استایل و ظاهر', 'woolentor' ),
            ]
        );
             


$this->add_control(
'sepidcolor-1',
			[
				'label' => __( 'رنگ پس زمینه تب ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tablinks' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		$this->add_control(
'sepidcolor-2',
			[
				'label' => __( 'رنگ متن تب ', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tablinks' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   $this->add_control(
'sepidcolor-3',
			[
				'label' => __( 'رنگ پس زمینه تب فعال', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tablinks.active' => 'background: {{VALUE}} !important',
				],
			]
           );
		      $this->add_control(
'sepidcolor-4',
			[
				'label' => __( 'رنگ متن تب فعال', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .tablinks.active' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   	      $this->add_control(
'sepidcolor-5',
			[
				'label' => __( 'رنگ پس زمینه تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan-tab' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   		
		   		   	      $this->add_control(
'sepidcolor-7',
			[
				'label' => __( 'رنگ متن تخفیف', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .mizan-tab' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
					 		   	      $this->add_control(
'sepidcolor-8',
			[
				'label' => __( 'رنگ عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-meta-tab-p h3' => 'color: {{VALUE}} !important',
				],
			]
           );
			 		   	      $this->add_control(
'sepidcolor-9',
			[
				'label' => __( 'رنگ کنار عنوان', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .box-meta-tab-p h3::before' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   					 		   	      $this->add_control(
'sepidcolor-10',
			[
				'label' => __( 'رنگ قیمت تخفیف خورده', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-donya-list-tab .asdfsadf444price del' => 'color: {{VALUE}} !important',
				],
			]
           );
		      					 		   	      $this->add_control(
'sepidcolor-11',
			[
				'label' => __( 'رنگ قیمت اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .product-donya-list-tab .asdfsadf444price' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .product-donya-list-tab .asdfsadf444price ins' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		      					 		   	      $this->add_control(
'sepidcolor-12',
			[
				'label' => __( 'رنگ پس زمینه نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-button .box-price-tedad144' => 'background: {{VALUE}} !important',
				],
			]
           );
		   			 		   	      $this->add_control(
'sepidcolor-13',
			[
				'label' => __( 'رنگ متن نوع دوره', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-button .box-price-tedad144' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   			 		   	      $this->add_control(
'sepidcolor-14',
			[
				'label' => __( 'رنگ پس زمینه تعداد دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-button .sath-dore-con' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   			 		   	      $this->add_control(
'sepidcolor-15',
			[
				'label' => __( 'رنگ متن تعدادت دانشجو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-button .sath-dore-con' => 'color: {{VALUE}} !important',
				],
			]
           );
		     			 		   	      $this->add_control(
'sepidcolor-14f',
			[
				'label' => __( 'رنگ پس زمینه ویدیو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .video-box-tab1' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   			 		   	      $this->add_control(
'sepidcolor-15f',
			[
				'label' => __( 'رنگ ایکون ویدیو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .video-box-tab1' => 'color: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   
		        			 		   	      $this->add_control(
'sepidcolor-14frr',
			[
				'label' => __( 'رنگ هاور پس زمینه ویدیو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .video-box-tab1:hover' => 'background: {{VALUE}} !important',
				],
			]
           );
		   
		   
		   			 		   	      $this->add_control(
'sepidcolor-15frrr',
			[
				'label' => __( 'رنگ هاور متن ویدیو', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .video-box-tab1:hover' => 'color: {{VALUE}} !important',
				],
			]
           );
		   $this->add_responsive_control(
                        'sepidborder-1',
                        [
                            'label' => esc_html__( 'گردی تب', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .tablinks' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		      $this->add_responsive_control(
                        'sepidborder2',
                        [
                            'label' => esc_html__( 'گردی کادر محصول', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-donya-list-tab' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		      $this->add_responsive_control(
                        'sepidborder24',
                        [
                            'label' => esc_html__( 'گردی تصویر', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .product-donya-list-tab img' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		     $this->add_responsive_control(
                        'sepidborder3',
                        [
                            'label' => esc_html__( 'گردی تخفیف', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .mizan-tab' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   $this->add_responsive_control(
                        'sepidborder4',
                        [
                            'label' => esc_html__( 'گردی ویدیو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .video-box-tab1' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
		   
		      $this->add_responsive_control(
                        'sepidborder5',
                        [
                            'label' => esc_html__( 'گردی نوع دوره', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-button .box-price-tedad144' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		     $this->add_responsive_control(
                        'sepidborder554',
                        [
                            'label' => esc_html__( 'گردی تعداد دانشجو', 'woolentor' ),
                            'type' => Controls_Manager::DIMENSIONS,
                            'selectors' => [
                                '{{WRAPPER}} .price-button .sath-dore-con' => 'border-radius: {{TOP}}px {{RIGHT}}px {{BOTTOM}}px {{LEFT}}px !important;',
                            ],
                        ]
                    );
		   
        $this->end_controls_section();

             


          



    }

    protected function render( $instance = [] ) {

        $settings           = $this->get_settings_for_display();
        $product_type       = $this->get_settings_for_display('woolentor_product_grid_product_filter');
        $per_page           = $this->get_settings_for_display('woolentor_product_grid_products_count');
        $custom_order_ck    = $this->get_settings_for_display('custom_order');
        $orderby            = $this->get_settings_for_display('orderby');
        $order              = $this->get_settings_for_display('order');
        $columns            = $this->get_settings_for_display('woolentor_product_grid_column');
        $rows               = $this->get_settings_for_display('woolentor_product_grid_row');
        $tabuniqid          = $this->get_id();
        $proslider          = $this->get_settings_for_display('proslider');
        $producttab          = $this->get_settings_for_display('producttab');

        $is_rtl = is_rtl();
        $direction = $is_rtl ? 'rtl' : 'ltr';
        $slider_settings = [
    
        ];

        $slider_responsive_settings = [
           

        ];

        $slider_settings = array_merge($slider_settings, $slider_responsive_settings);

        // WooCommerce Category
        $args = array(
            'post_type'             => 'product',
            'post_status'           => 'publish',
            'ignore_sticky_posts'   => 1,
            'posts_per_page'        => $per_page,
        );

        switch( $product_type ){

            case 'sale':
                $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
            break;

            case 'featured':
                $args['tax_query'][] = array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'name',
                    'terms'    => 'featured',
                    'operator' => 'IN',
                );
            break;

            case 'best_selling':
                $args['meta_key']   = 'total_sales';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';
            break;

            case 'top_rated': 
                $args['meta_key']   = '_wc_average_rating';
                $args['orderby']    = 'meta_value_num';
                $args['order']      = 'desc';          
            break;

            case 'mixed_order':
                $args['orderby']    = 'rand';
            break;

            default: /* Recent */
                $args['orderby']    = 'date';
                $args['order']      = 'desc';
            break;
        }

        // Custom Order
        if( $custom_order_ck == 'yes' ){
            $args['orderby'] = $orderby;
            $args['order'] = $order;
        }

        $get_product_categories = $settings['woolentor_product_grid_categories']; // get custom field value
        $product_cats = str_replace(' ', '', $get_product_categories);

        if ( "0" != $get_product_categories) {
            if( is_array($product_cats) && count($product_cats) > 0 ){
                $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                $args['tax_query'] = array(
                    array(
                        'taxonomy' => 'product_cat',
                        'terms' => $product_cats,
                        'field' => $field_name,
                        'include_children' => false
                    )
                );
            }
        }

        $products = new \WP_Query( $args );

        $tabmenu = 'yes';

        if( ($proslider == 'yes') && ( $producttab != 'yes' ) ){
            $collumval = 'slide-item ht-col-xs-12';
        }else{
            $collumval = 'product-list-tab1';
            if( $columns !='' ){
                if( $columns == 5){
                    $collumval = 'product-list-tab1';
                }else{
                    $colwidth = round(12/$columns);
                    $collumval = 'ht-col-lg-'.$colwidth.'product-list-tab1';
                }
            }
        }

        ?>
                  <?php if ( $producttab == 'yes' ) { ?>
		
                <div class="product-tab-list ht-text-center">
                    <ul class="ht-tab-menus tab">
                        <?php
                            $m=0;
                            if( is_array( $product_cats ) && count( $product_cats ) > 0 ){

                                // Category retrive
                                $catargs = array(
                                    'orderby'    => 'name',
                                    'order'      => 'ASC',
                                    'hide_empty' => true,
                                    'slug'       => $product_cats,
                                );
                                $prod_categories = get_terms( 'product_cat', $catargs);

                                foreach( $prod_categories as $prod_cats ){
                                    $m++;
                                    $field_name = is_numeric( $product_cats[0] ) ? 'term_id' : 'slug';
                                    $args['tax_query'] = array(
                                        array(
                                            'taxonomy' => 'product_cat',
                                            'terms' => $prod_cats,
                                            'field' => $field_name,
                                            'include_children' => false
                                        ),
                                    );
                                    if( 'featured' == $product_type ){
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_visibility',
                                            'field'    => 'name',
                                            'terms'    => 'featured',
                                            'operator' => 'IN',
                                        );
                                    }
                                    $fetchproduct = new \WP_Query( $args );

                                    if( $fetchproduct->have_posts() ){
                                        ?>
										
										  <button class="tablinks tablinks<?php echo '' . $settings['code'] . ''; ?> <?php if($m==1){ echo 'active';}?>" onclick="openCity<?php echo '' . $settings['code'] . ''; ?>(event, 'sepidtab<?php echo $tabuniqid.esc_attr($m);?>')">                                                <?php echo esc_attr( $prod_cats->name,'woolentor' );?>
</button>
                                          
                                        <?php
                                    }
                                }
                            }
                        ?>
                    </ul>
                </div>
            <?php }; ?>
			
			           <?php if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ): ?>
                
            <?php
                $j=0;
                $tabcatargs = array(
                    'orderby'    => 'name',
                    'order'      => 'ASC',
                    'hide_empty' => true,
                    'slug'       => $product_cats,
                );
                $tabcat_fach = get_terms( 'product_cat', $tabcatargs );
                foreach( $tabcat_fach as $cats ):
                    $j++;
                    $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                    $args['tax_query'] = array(
                        array(
                            'taxonomy' => 'product_cat',
                            'terms' => $cats,
                            'field' => $field_name,
                            'include_children' => false
                        )
                    );
                    if( 'featured' == $product_type ){
                        $args['tax_query'][] = array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'featured',
                            'operator' => 'IN',
                        );
                    }
                    $products = new \WP_Query( $args );

                    if( $products->have_posts() ):
                    ?>
			
                    <div  class="sepid-ht-tab-pane sepid-ht-tab-pane<?php echo '' . $settings['code'] . ''; ?> <?php if($j==1){echo 'htactive';} ?>" id="<?php echo 'sepidtab'.$tabuniqid.$j;?>">
                        
                        <div class="ht-row">
                            <div class="<?php echo esc_attr( $collumval );?>">
                                <?php
                                    $k=1;
                                    while( $products->have_posts() ): $products->the_post();
                                ?>


<div class="product-donya-list-tab">
<div class="product-donya-list-tab-box">
<a href="<?php the_permalink(); ?>">

<div class="product-donya-list-tab-box-img">

<?php the_post_thumbnail(''); ?>


</div></a>
<div class="box-meta-tab-p">

							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<?php $option_meta = rwmb_meta('video'); if (!empty($option_meta)) { ?>

<div class="vide-box-tab">




 <!-- Trigger/Open The Modal -->

<!-- The Modal -->
<div id="myModal<?php echo get_the_ID(); ?>" class="modal<?php echo get_the_ID(); ?> modaliraniboxvideo">

  <!-- Modal content -->
  <div class="modal-content<?php echo get_the_ID(); ?> conteniranboxi">


  <div class="video3er34rwe">
  
  


  
    <span class="close<?php echo get_the_ID(); ?> closeiranvideo">&times;</span>
	<button class="tavaghof" onclick="pauseVid<?php echo get_the_ID(); ?>()" type="button">توقف ویدیو</button><br> 

      <div class="video3er34rwertyrt">
    
		
<div class="mvideo4">
<video id="myVideor<?php echo get_the_ID(); ?>" preload="none" controls="" poster="<?php $option_meta = rwmb_meta('tasvirv'); if (!empty($option_meta)) { ?><?php echo $option_meta; ?><?php } ?>
">
                        <source src="<?php $option_meta = rwmb_meta('video'); if (!empty($option_meta)) { ?><?php echo $option_meta; ?><?php } ?>" type="video/mp4">
                    </video>
</div>


<script> 

var vid<?php echo get_the_ID(); ?> = document.getElementById("myVideor<?php echo get_the_ID(); ?>"); 


function pauseVid<?php echo get_the_ID(); ?>() { 
  vid<?php echo get_the_ID(); ?>.pause(); 
} 


</script> 


</div></div>
  </div>

</div> 

<div class="video-box-tab1" id="myBtn<?php echo get_the_ID(); ?>">
<i class="fi fi-rr-play"></i></div>

<script>

// Get the modal
var modal<?php echo get_the_ID(); ?> = document.getElementById("myModal<?php echo get_the_ID(); ?>");

// Get the button that opens the modal
var btn = document.getElementById("myBtn<?php echo get_the_ID(); ?>");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close<?php echo get_the_ID(); ?>")[0];

// When the user clicks on the button, open the modal
btn.onclick = function() {
  modal<?php echo get_the_ID(); ?>.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal<?php echo get_the_ID(); ?>.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal<?php echo get_the_ID(); ?>) {
    modal<?php echo get_the_ID(); ?>.style.display = "none";
  }
} 
</script>
</div><?php } ?><?php } ?><a href="<?php the_permalink(); ?>">

<h3><?php the_title(); ?></h3>
<div class="asdfsadf444price"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<?php global $product; if ( $product->is_on_sale() ) : ?>


<div class="mizan-tab">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>


</div>
	<?php
endif;
?><?php } ?>
<div class="price-two-box">
<?php global $product; echo $product->get_price_html(); ?>

	</div>
	</div></a>
	<div class="price-button"><?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
	   					<?php $option_meta = rwmb_meta('nodor'); if (!empty($option_meta)) { ?>

<div class="box-price-tedad144"> <?php echo $option_meta; ?></div>
 <?php } ?><?php } ?><?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>
	<div class="sath-dore-con"><i class="fi fi-rr-user"></i>
  <?php global $product;
$units_sold = get_post_meta( $product->get_id(), 'total_sales', true );
echo ''. sprintf( __( '%s', 'woocommerce' ), $units_sold ).''; ?> 

دانشجو
</div><?php } ?>
	
</div></div>

</div>
</div>
                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval);?>">
                                <?php } $k++; endwhile; wp_reset_postdata(); ?>
                            </div>
                        </div>

                    </div>
                <?php endif; endforeach;?>

            <?php else:?>
        <div class="ps2 product-style htpp">

     

  
                <div class="ht-row roozaye-barfi">


                        <div class="<?php echo esc_attr( $collumval );?>">
                            <?php
                                $k=1;
                                if( $products->have_posts() ):
                                    while( $products->have_posts() ): $products->the_post();
                            ?>
<div class="product-donya-list-tab">
<div class="product-donya-list-tab-box">
<a href="<?php the_permalink(); ?>">

<div class="product-donya-list-tab-box-img">

<?php the_post_thumbnail(''); ?>


</div></a>
<div class="box-meta-tab-p">

							<?php if ( 'yes' === $settings['farnamoneshow1'] ) { ?>

<?php $option_meta = rwmb_meta('video'); if (!empty($option_meta)) { ?>

<div class="vide-box-tab">




 <!-- Trigger/Open The Modal -->

<!-- The Modal -->
<div id="myModal<?php echo get_the_ID(); ?>" class="modal<?php echo get_the_ID(); ?> modaliraniboxvideo">

  <!-- Modal content -->
  <div class="modal-content<?php echo get_the_ID(); ?> conteniranboxi">
  
  <div class="video3er34rwe">
    <span class="close<?php echo get_the_ID(); ?> closeiranvideo">&times;</span>
      <div class="video3er34rwertyrt">
    
		
<div class="mvideo4">
<video controls="" poster="<?php $option_meta = rwmb_meta('tasvirv'); if (!empty($option_meta)) { ?><?php echo $option_meta; ?><?php } ?>
">
                        <source src="<?php $option_meta = rwmb_meta('video'); if (!empty($option_meta)) { ?><?php echo $option_meta; ?><?php } ?>" type="video/mp4">
                    </video>
</div>

</div></div>
  </div>

</div> 

<div class="video-box-tab1" id="myBtn<?php echo get_the_ID(); ?>">
<i class="fi fi-rr-play"></i></div>

<script>

// Get the modal
var modal<?php echo get_the_ID(); ?> = document.getElementById("myModal<?php echo get_the_ID(); ?>");

// Get the button that opens the modal
var btn = document.getElementById("myBtn<?php echo get_the_ID(); ?>");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close<?php echo get_the_ID(); ?>")[0];

// When the user clicks on the button, open the modal
btn.onclick = function() {
  modal<?php echo get_the_ID(); ?>.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
  modal<?php echo get_the_ID(); ?>.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
  if (event.target == modal<?php echo get_the_ID(); ?>) {
    modal<?php echo get_the_ID(); ?>.style.display = "none";
  }
} 
</script>
</div><?php } ?><?php } ?><a href="<?php the_permalink(); ?>">

<h3><?php the_title(); ?></h3>
<div class="asdfsadf444price"><?php if ( 'yes' === $settings['farnamoneshow2'] ) { ?>
<?php global $product; if ( $product->is_on_sale() ) : ?>


<div class="mizan-tab">
	<?php echo apply_filters( 'woocommerce_sale_flashtwo', $product ); ?>


</div>
	<?php
endif;
?><?php } ?>
<div class="price-two-box">
<?php global $product; echo $product->get_price_html(); ?>

	</div>
	</div></a>
	<div class="price-button"><?php if ( 'yes' === $settings['farnamoneshow3'] ) { ?>
	   					<?php $option_meta = rwmb_meta('nodor'); if (!empty($option_meta)) { ?>

<div class="box-price-tedad144"> <?php echo $option_meta; ?></div>
 <?php } ?><?php } ?><?php if ( 'yes' === $settings['farnamoneshow4'] ) { ?>
	<div class="sath-dore-con"><i class="fi fi-rr-user"></i>
  <?php global $product;
$units_sold = get_post_meta( $product->get_id(), 'total_sales', true );
echo ''. sprintf( __( '%s', 'woocommerce' ), $units_sold ).''; ?> 

دانشجو
</div><?php } ?>
	
</div></div>

</div>
</div>
 

                           <?php if ($k % $rows == 0 && ($products->post_count != $k)) { ?>
                            </div>
                            <div class="<?php echo esc_attr($collumval );?>">
                                <?php } $k++; endwhile; wp_reset_postdata();  endif; ?>
                            </div>
                    <?php if( $proslider == 'yes' ){ echo '</div>';} ?>
                </div>       
            <?php endif;?>

		<script>
					function openCity<?php echo '' . $settings['code'] . ''; ?>(evt, cityName<?php echo '' . $settings['code'] . ''; ?>) {
  // Declare all variables
  var i, sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>, tablinks<?php echo '' . $settings['code'] . ''; ?>;

  // Get all elements with class="sepidhttabpane" and hide them
  sepidhttabpane<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("sepid-ht-tab-pane<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    sepidhttabpane<?php echo '' . $settings['code'] . ''; ?>[i].style.display = "none";
  }

  // Get all elements with class="tablinks" and remove the class "active"
  tablinks<?php echo '' . $settings['code'] . ''; ?> = document.getElementsByClassName("tablinks<?php echo '' . $settings['code'] . ''; ?>");
  for (i = 0; i < tablinks<?php echo '' . $settings['code'] . ''; ?>.length; i++) {
    tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className = tablinks<?php echo '' . $settings['code'] . ''; ?>[i].className.replace(" active", "");
  }

  // Show the current tab, and add an "active" class to the button that opened the tab
  document.getElementById(cityName<?php echo '' . $settings['code'] . ''; ?>).style.display = "block";
  evt.currentTarget.className += " active";
} 
					</script>

        <?php

    }


}


