<?php
namespace Elementor;

class box2 extends Widget_Base {
	
	public function get_name() {
		return 'box2';
	}
	
	public function get_title() {
		return 'دسته بندی';
	}
	
	public function get_icon() {
		return 'eicon-navigator';
	}
	
	public function get_categories() {
		return [ 'yadgiri' ];
	}
	
	protected function register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'elementor' ),
			]
		);
		
		$this->add_control(
			'title',
			[
				'label' => __( 'عنوان', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'عنوان خود را وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'link',
			[
				'label' => __( 'لینک دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'ادرس لینک را وارد کنید', 'elementor' ),
			]
		);
				$this->add_control(
			'code',
			[
				'label' => __( 'کد این دسته بندی', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'مثلا d43', 'elementor' ),
			]
		);
		$this->add_control(
			'zirtitle',
			[
				'label' => __( 'توضیحات', 'elementor' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'توضیحات کوتاه خود را وارد کنید', 'elementor' ),
			]
		);

$this->add_control(
			'icon',
			[
				'label' => __( 'ایکون اصلی', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'icon1',
			[
				'label' => __( 'ایکون پس زمینه', 'text-domain' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
			$this->add_control(
			'title_color',
			[
				'label' => __( 'رنگ اصلی', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
			$this->add_control(
			'title_color1',
			[
				'label' => __( 'رنگ ثانویه', 'plugin-domain' ),
				'type' => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings_for_display();
		
		echo  "
<a class='box-daste-newise $settings[code]' target='_blank' href='$settings[link]'>
<style>

.$settings[code] .my-icon-wrapper i {
	background: $settings[title_color];
}

.$settings[code] .my-icon-wrapper i {
	color: $settings[title_color1];
}

</style>

";

		?>
		<div class="my-icon-wrapper">
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?>
		</div>
		<?php
		?>
		<div class="neshoon-yadgiri">
			<?php \Elementor\Icons_Manager::render_icon( $settings['icon1'], [ 'aria-hidden' => 'true' ] ); ?>
		</div>
		<?php
				echo  "



<h5 style='color: $settings[title_color1]'> $settings[title]</h5><p> $settings[zirtitle]</p> </a>";

	}


	
	protected function _content_template() {

    }
	
	
}