<?php
/**
 * Downloads
 *
 * Shows downloads on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/downloads.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$downloads     = WC()->customer->get_downloadable_products();
$has_downloads = (bool) $downloads;

do_action( 'woocommerce_before_account_downloads', $has_downloads ); ?>
<div class="newdownload-1233">
<?php if ( $has_downloads ) : ?>

	<?php do_action( 'woocommerce_before_available_downloads' ); ?>

	<?php function wdm_print_download_file_name( $download, $product_meta ) {
if ( is_numeric( $download['downloads_remaining'] ) )
    echo apply_filters( 'woocommerce_available_download_count', '<span class="count">' . sprintf( _n( '%s download remaining', '%s downloads remaining', $download['downloads_remaining'], 'woocommerce' ), $download['downloads_remaining'] ) . '</span> ', $download );

echo apply_filters( 'woocommerce_available_download_link', '<a href="' . esc_url( $download['download_url'] ) . '"><span>' . $product_meta[$download['download_id']]['name'] . '</span></a>', $download ); //Print file name
}

if ( $downloads = WC()->customer->get_downloadable_products() ) :
?>


<div class="digital-downloads">
    <?php
    $all_product_ids = array();
    $all_download_ids = array();
    foreach ( $downloads as $download ) :
        ?>
        <?php
        do_action( 'woocommerce_available_download_start', $download );

        if ( !in_array( $download['product_id'], $all_product_ids ) ) { //Check if current product id is already there in $all_product_ids array. If it goes in this loop, that means it is new product id
            $product_meta = get_post_meta( $download['product_id'], '_downloadable_files', true ); //All download ids of the product

            $all_product_ids[] = $download['product_id']; //Push Current download's Product id to an array

            $all_download_ids = array_keys( $product_meta ); //Get all download ids of the current product

            echo '
<div class="download-title"><span>' . get_the_title( $download['product_id'] ) . '</span></div>'; //Print product name

        } else { 
            //product id is already in use.
        }

        echo '<div class="download-product">';
        wdm_print_download_file_name( $download, $product_meta );
        echo '</div>';

        do_action( 'woocommerce_available_download_end', $download );

        ?>
    <?php endforeach; ?>
</div>
<?php endif; ?>

	<?php do_action( 'woocommerce_after_available_downloads' ); ?>

<?php else : ?>
	<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">
		<a class="woocommerce-Button button" href="<?php echo esc_url( apply_filters( 'woocommerce_return_to_shop_redirect', wc_get_page_permalink( 'shop' ) ) ); ?>">
			<?php esc_html_e( 'Browse products', 'woocommerce' ); ?>
		</a>
		<?php esc_html_e( 'No downloads available yet.', 'woocommerce' ); ?>
	</div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_account_downloads', $has_downloads ); ?>
</div>